<?php
get_header();
?>
<main class="icpl-content">
  <?php $icpl_has_sidebar = is_active_sidebar('sidebar-1'); ?>
  <div class="icpl-container <?php echo $icpl_has_sidebar ? 'icpl-layout' : ''; ?>">
    <div class="icpl-main">
      <div class="icpl-card icpl-entry">
        <h1><?php the_archive_title(); ?></h1>
        <?php the_archive_description('<div class="icpl-post-excerpt">', '</div>'); ?>
      </div>

      <?php if (have_posts()): ?>
        <div class="icpl-post-list">
          <?php while (have_posts()): the_post(); ?>
            <article <?php post_class('icpl-card icpl-entry'); ?>>
              <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
              <div class="icpl-post-meta"><?php echo esc_html(get_the_date()); ?></div>
              <div class="icpl-post-excerpt"><?php the_excerpt(); ?></div>
            </article>
          <?php endwhile; ?>
        </div>

        <div class="icpl-pagination">
          <div><?php previous_posts_link(__('Newer', 'icpl-ichimaru-plus')); ?></div>
          <div><?php next_posts_link(__('Older', 'icpl-ichimaru-plus')); ?></div>
        </div>
      <?php else: ?>
        <div class="icpl-card icpl-entry">
          <p><?php esc_html_e('No posts found.', 'icpl-ichimaru-plus'); ?></p>
        </div>
      <?php endif; ?>
    </div>
    <?php if ($icpl_has_sidebar) : ?>
      <?php get_sidebar(); ?>
    <?php endif; ?>
  </div>
</main>
<?php get_footer(); ?>
