<?php
/**
 * Front Page
 *
 * - ヒーローは template-parts/hero に集約。
 * - それ以外は「フロントページに指定された固定ページ」の本文を表示。
 * - サイドバーはウィジェットが設定されている場合のみ表示。
 */

if (!defined('ABSPATH')) {
    exit;
}

get_header();
?>

<?php get_template_part('template-parts/hero'); ?>

<?php
// Latest News (customizable via Customizer)
if (function_exists('icpl_render_latest_news')) {
    icpl_render_latest_news();
}
?>

<section class="icpl-content">
  <div class="icpl-container icpl-layout">

    <main class="icpl-main">
      <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
        <div class="icpl-card icpl-entry">
          <?php the_content(); ?>
        </div>
      <?php endwhile; endif; ?>
    </main>

    <?php if (is_active_sidebar('sidebar-1')) : ?>
      <?php get_sidebar(); ?>
    <?php endif; ?>

  </div>
</section>

<?php
get_footer();
