<?php
if (!defined('ABSPATH')) { exit; }
?><!doctype html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo('charset'); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<?php
// === ICPL DEBUG MARKER (remove after verification) ===
// View Source で必ず見えるように HTML コメントを出す
$icpl_debug_stamp = gmdate('Y-m-d H:i:s') . ' UTC';
echo "<!-- ICPL_HEADER_LOADED icpl-ichimaru-plus {$icpl_debug_stamp} -->\n";

// 管理者だけ、画面上にも小さく表示（キャッシュや別テーマ切り分け用）
if (current_user_can('manage_options')) {
  echo '<div style="position:fixed;z-index:999999;bottom:10px;right:10px;padding:6px 10px;background:#111827;color:#fff;font-size:12px;border-radius:8px;opacity:.75;">ICPL header loaded: ' . esc_html($icpl_debug_stamp) . '</div>';
}
?>

<header class="icpl-header icpl-accent-bg">
  <div class="icpl-container icpl-header-inner">
    <div class="icpl-brand">
      <div class="icpl-branding">
        <?php
          $icpl_logo_id = (int) get_theme_mod('custom_logo');
          $icpl_logo_h  = (int) get_theme_mod('icpl_logo_max_height', 44);
          if ($icpl_logo_h < 16) { $icpl_logo_h = 16; }
          if ($icpl_logo_h > 120) { $icpl_logo_h = 120; }

          $icpl_has_logo = false;

          if ($icpl_logo_id > 0) {
            $mime = (string) get_post_mime_type($icpl_logo_id);

            // === SVG : INLINE SVG（最終兵器・HTML直書き） ===
            if ($mime === 'image/svg+xml') {
              $path = get_attached_file($icpl_logo_id);
              if ($path && is_readable($path)) {
                $svg = file_get_contents($path);
                if ($svg !== false) {
                  // 不要な XML 宣言を除去（HTML内で壊れないように）
                  $svg = preg_replace('/<\?xml.*?\?>/i', '', $svg);
                  
                  echo '<a class="icpl-custom-logo-link" href="' . esc_url(home_url('/')) . '" aria-label="' . esc_attr(get_bloginfo('name')) . '" style="display:inline-flex;align-items:center;">';
                  echo '<span class="icpl-inline-svg" style="display:inline-block;height:' . $icpl_logo_h . 'px;">';
                  echo $svg;
                  echo '</span>';
                  echo '</a>';

                  // SVG 自体に高さを強制（viewBox無し対策）
                  echo '<style>.icpl-inline-svg svg{height:' . $icpl_logo_h . 'px;width:auto;display:block;}</style>';

                  $icpl_has_logo = true;
                }
              }
            }

            // === PNG / JPG fallback ===
            if (!$icpl_has_logo && function_exists('the_custom_logo')) {
              the_custom_logo();
              $icpl_has_logo = true;
            }
          }

          // 最終フォールバック（何も出なかった場合）
          if (!$icpl_has_logo && function_exists('get_custom_logo')) {
            $tmp = get_custom_logo();
            if (!empty($tmp)) {
              echo $tmp;
              $icpl_has_logo = true;
            }
          }
        ?>

        <?php
          // $icpl_has_logo は上のロゴ出力ブロックで確定済み
          $icpl_show_title    = (int) get_theme_mod('icpl_show_site_title', 1);
          $icpl_show_tagline  = (int) get_theme_mod('icpl_show_tagline', 1);

          // ロゴが無いのにタイトルも非表示だと何も残らないため、この場合はタイトルを強制表示する。
          if (!$icpl_has_logo && $icpl_show_title !== 1) {
            $icpl_show_title = 1;
          }
        ?>

        <div class="icpl-brand-text">
          <?php if ($icpl_show_title === 1): ?>
            <?php if (is_front_page() && is_home()): ?>
              <h1 class="icpl-site-title"><a href="<?php echo esc_url(home_url('/')); ?>"><?php bloginfo('name'); ?></a></h1>
            <?php else: ?>
              <p class="icpl-site-title"><a href="<?php echo esc_url(home_url('/')); ?>"><?php bloginfo('name'); ?></a></p>
            <?php endif; ?>
          <?php endif; ?>

          <?php if ($icpl_show_tagline === 1): ?>
            <p class="icpl-site-desc"><?php bloginfo('description'); ?></p>
          <?php endif; ?>
        </div>
      </div>
    </div>

    <button class="icpl-menu-toggle" aria-expanded="false" aria-controls="primary-menu" style="display:none;background:none;border:0;color:inherit;font-size:24px;cursor:pointer;">
      <span class="sr-only">Menu</span>
      ☰
    </button>
    <div class="icpl-menu-overlay" aria-hidden="true"></div>
    <nav class="icpl-nav" id="primary-menu" aria-label="<?php esc_attr_e('Primary Menu', 'icpl-ichimaru-plus'); ?>">
      <?php
        wp_nav_menu(array(
          'theme_location' => 'primary',
          'container'      => false,
          'fallback_cb'    => function () {
              echo '<ul class="menu"><li><a href="' . esc_url(home_url('/')) . '">Home</a></li></ul>';
          }
        ));
      ?>
    </nav>
  </div>
  <style>
/* === Temporary Hamburger Menu (mobile only) === */
@media (max-width: 768px) {
  /* show button */
  .icpl-menu-toggle {
    display: inline-flex !important;
    align-items: center;
    justify-content: center;
    margin-left: auto;
    padding: 8px 10px;
    border-radius: 10px;
    z-index: 1000002;
  }

  /* overlay */
  .icpl-menu-overlay {
    position: fixed;
    inset: 0;
    background: rgba(0,0,0,.45);
    opacity: 0;
    pointer-events: none;
    transition: opacity .2s ease;
    z-index: 1000000;
  }
  .icpl-menu-overlay.is-open {
    opacity: 1;
    pointer-events: auto;
  }

  /* right drawer nav */
  .icpl-nav {
    position: fixed;
    top: 0;
    right: 0;
    height: 100vh;
    width: min(86vw, 360px);
    background: var(--icpl-surface);
    border-left: 1px solid var(--icpl-border);
    box-shadow: -10px 0 30px rgba(0,0,0,.25);
    transform: translateX(102%);
    transition: transform .25s ease;
    z-index: 1000001;
    overflow-y: auto;
    -webkit-overflow-scrolling: touch;
    padding: 12px 0;
  }

  .icpl-nav.is-open {
    transform: translateX(0);
  }

  /* force vertical stacked menu list */
  .icpl-nav ul.menu {
    list-style: none;
    margin: 0;
    padding: 6px 0;
    display: block !important;
  }

  .icpl-nav ul.menu > li {
    margin: 0;
    display: block !important;
    float: none !important;
    width: 100% !important;
  }

  .icpl-nav ul.menu > li + li {
    border-top: 1px solid var(--icpl-border);
  }

  .icpl-nav ul.menu a {
    display: block;
    padding: 14px 16px;
    color: var(--icpl-text);
    text-decoration: none;
  }

  .icpl-nav ul.menu a:hover {
    background: rgba(0,0,0,.06);
  }

  /* header inner wrap (keep brand + button on one line) */
  .icpl-header-inner {
    flex-wrap: nowrap;
  }

  /* prevent body scroll when open */
  body.icpl-menu-open {
    overflow: hidden;
  }
}

@media (min-width: 769px) {
  .icpl-header-inner {
    flex-wrap: nowrap;
  }
}
</style>

<script>
(function(){
  var btn = document.querySelector('.icpl-menu-toggle');
  var nav = document.querySelector('.icpl-nav');
  var ovl = document.querySelector('.icpl-menu-overlay');
  if (!btn || !nav || !ovl) return;

  function setState(open){
    if (open) {
      nav.classList.add('is-open');
      ovl.classList.add('is-open');
      document.body.classList.add('icpl-menu-open');
      btn.setAttribute('aria-expanded', 'true');
      btn.innerHTML = '<span class="sr-only">Close</span> ✕';
    } else {
      nav.classList.remove('is-open');
      ovl.classList.remove('is-open');
      document.body.classList.remove('icpl-menu-open');
      btn.setAttribute('aria-expanded', 'false');
      btn.innerHTML = '<span class="sr-only">Menu</span> ☰';
    }
  }

  // initial state
  setState(false);

  btn.addEventListener('click', function(){
    var open = !nav.classList.contains('is-open');
    setState(open);
  });

  // close on overlay click
  ovl.addEventListener('click', function(){
    setState(false);
  });

  // close after tapping a link
  nav.addEventListener('click', function(e){
    var a = e.target && e.target.closest ? e.target.closest('a') : null;
    if (!a) return;
    setState(false);
  });

  // close on ESC
  document.addEventListener('keydown', function(e){
    if (e.key === 'Escape') setState(false);
  });
})();
</script>
</header>

<?php
// Hero injection point (render hero AFTER header, not before)
do_action('icpl_after_header');
?>