<?php
get_header();
?>
<main class="icpl-content">
  <?php $icpl_has_sidebar = is_active_sidebar('sidebar-1'); ?>
  <div class="icpl-container icpl-layout <?php echo $icpl_has_sidebar ? 'has-sidebar' : 'no-sidebar'; ?>">
    <div class="icpl-main">
      <?php if (have_posts()): ?>
        <div class="icpl-post-list">
          <?php while (have_posts()): the_post(); ?>
            <article <?php post_class('icpl-card icpl-entry'); ?>>
              <header>
                <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                <div class="icpl-post-meta">
                  <span><?php echo esc_html(get_the_date()); ?></span>
                  <span> / </span>
                  <span><?php the_author_posts_link(); ?></span>
                </div>
              </header>
              <div class="icpl-post-excerpt">
                <?php the_excerpt(); ?>
              </div>
            </article>
          <?php endwhile; ?>
        </div>

        <div class="icpl-pagination">
          <div><?php previous_posts_link(__('Newer Posts', 'icpl-ichimaru-plus')); ?></div>
          <div><?php next_posts_link(__('Older Posts', 'icpl-ichimaru-plus')); ?></div>
        </div>
      <?php else: ?>
        <div class="icpl-card icpl-entry">
          <h2><?php esc_html_e('Nothing Found', 'icpl-ichimaru-plus'); ?></h2>
          <p><?php esc_html_e('No posts matched your criteria.', 'icpl-ichimaru-plus'); ?></p>
        </div>
      <?php endif; ?>
    </div>

    <?php if ($icpl_has_sidebar) : ?>
      <?php get_sidebar(); ?>
    <?php endif; ?>
  </div>
</main>
<?php
get_footer();
