<?php
get_header();
?>
<main class="icpl-content">
  <div class="icpl-container icpl-layout">
    <div class="icpl-main">
      <div class="icpl-card icpl-entry">
        <h1><?php printf(esc_html__('Search Results for: %s', 'icpl-ichimaru-plus'), get_search_query()); ?></h1>
      </div>

      <?php if (have_posts()): ?>
        <div class="icpl-post-list">
          <?php while (have_posts()): the_post(); ?>
            <article <?php post_class('icpl-card icpl-entry'); ?>>
              <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
              <div class="icpl-post-excerpt"><?php the_excerpt(); ?></div>
            </article>
          <?php endwhile; ?>
        </div>
      <?php else: ?>
        <div class="icpl-card icpl-entry">
          <p><?php esc_html_e('No results found. Try a different search.', 'icpl-ichimaru-plus'); ?></p>
          <?php get_search_form(); ?>
        </div>
      <?php endif; ?>
    </div>
    <?php get_sidebar(); ?>
  </div>
</main>
<?php get_footer(); ?>
