<?php
if (!defined('ABSPATH')) { exit; }
?>
<aside class="icpl-sidebar">
  <?php if (is_active_sidebar('sidebar-1')): ?>
    <?php dynamic_sidebar('sidebar-1'); ?>
  <?php else: ?>
    <section class="icpl-card icpl-widget">
      <h2><?php esc_html_e('Search', 'icpl-ichimaru-plus'); ?></h2>
      <?php get_search_form(); ?>
    </section>
    <section class="icpl-card icpl-widget">
      <h2><?php esc_html_e('Recent Posts', 'icpl-ichimaru-plus'); ?></h2>
      <ul>
        <?php
          $recent = wp_get_recent_posts(array('numberposts' => 5, 'post_status' => 'publish'));
          foreach ($recent as $post) {
            echo '<li><a href="' . esc_url(get_permalink($post['ID'])) . '">' . esc_html($post['post_title']) . '</a></li>';
          }
        ?>
      </ul>
    </section>
  <?php endif; ?>
</aside>
