<?php
get_header();
?>
<main class="icpl-content">
  <?php $icpl_has_sidebar = is_active_sidebar('sidebar-1'); ?>
  <div class="icpl-container <?php echo $icpl_has_sidebar ? 'icpl-layout' : ''; ?>">
    <div class="icpl-main">
      <?php while (have_posts()): the_post(); ?>
        <article <?php post_class('icpl-card icpl-entry'); ?>>
          <h1><?php the_title(); ?></h1>
          <?php the_content(); ?>
          <?php wp_link_pages(); ?>
        </article>

        <div class="icpl-pagination">
          <div><?php previous_post_link('%link', __('← 前の記事', 'icpl-ichimaru-plus')); ?></div>
          <div><?php next_post_link('%link', __('次の記事 →', 'icpl-ichimaru-plus')); ?></div>
        </div>

        <?php if (comments_open() || get_comments_number()): ?>
          <div class="icpl-card icpl-entry">
            <?php comments_template(); ?>
          </div>
        <?php endif; ?>

      <?php endwhile; ?>
    </div>
    <?php if ($icpl_has_sidebar) : ?>
      <?php get_sidebar(); ?>
    <?php endif; ?>
  </div>
</main>
<?php get_footer(); ?>
