<?php
if (!defined('ABSPATH')) exit;

// Hero settings
// Hero settings
$hero_title = trim((string) get_theme_mod('icpl_hero_title', '仕事とブランドを、きちんと伝える。'));
$hero_text  = trim((string) get_theme_mod(
    'icpl_hero_text',
    '軽量・堅牢・拡張しやすい。10+ は、ビジネスサイトに必要な王道レイアウトを最小構成で提供します。'
));
$cta_label  = trim((string) get_theme_mod('icpl_hero_cta_label', 'お問い合わせ'));
$cta_url    = trim((string) get_theme_mod('icpl_hero_cta_url', home_url('/contact/')));

$bg_type   = (string) get_theme_mod('icpl_hero_bg_type', 'none');
$bg_image  = (int) get_theme_mod('icpl_hero_bg_image', 0);
$bg_yt_url = trim((string) get_theme_mod('icpl_hero_bg_youtube', ''));

// Debug（管理者のみ・本番でも「表示されない」原因切り分け用）
$__icpl_len_title = strlen($hero_title);
$__icpl_len_text  = strlen($hero_text);
?>

<section class="icpl-hero"
  <?php if ($bg_type === 'youtube' && $bg_yt_url): ?>data-hero-youtube="1"<?php endif; ?>
  <?php if ($bg_type === 'image' && $bg_image): ?>data-hero-image="1"<?php endif; ?>
  data-icpl-hero-title-len="<?php echo esc_attr((string) $__icpl_len_title); ?>"
  data-icpl-hero-text-len="<?php echo esc_attr((string) $__icpl_len_text); ?>"
>
  <?php if (current_user_can('manage_options')): ?>
    <!-- ICPL HERO DEBUG: title_len=<?php echo (int) $__icpl_len_title; ?> text_len=<?php echo (int) $__icpl_len_text; ?> bg_type=<?php echo esc_html($bg_type); ?> bg_image=<?php echo (int) $bg_image; ?> yt_url_len=<?php echo (int) strlen($bg_yt_url); ?> -->
  <?php endif; ?>
  <div class="icpl-hero-bg">
    <?php
      // Image background
      if ($bg_type === 'image' && $bg_image) {
          echo wp_get_attachment_image($bg_image, 'full', false, array('class' => 'icpl-hero-bg-image'));
      }

      // PHP fallback: output iframe directly (in case JS injection is blocked / not loaded).
      $icpl_video_id = '';
      if ($bg_type === 'youtube' && !empty($bg_yt_url)) {
          if (function_exists('icpl_extract_youtube_video_id')) {
              $icpl_video_id = icpl_extract_youtube_video_id($bg_yt_url);
          } else {
              // Minimal fallback extractor
              if (preg_match('~youtu\\.be/([A-Za-z0-9_-]{6,})~', $bg_yt_url, $m)) {
                  $icpl_video_id = $m[1];
              } else {
                  $q = wp_parse_url($bg_yt_url, PHP_URL_QUERY);
                  if ($q) {
                      parse_str($q, $args);
                      if (!empty($args['v'])) {
                          $icpl_video_id = preg_replace('~[^A-Za-z0-9_-]~', '', (string) $args['v']);
                      }
                  }
              }
          }
      }

      if (!empty($icpl_video_id)):
          $start = (int) get_theme_mod('icpl_hero_bg_youtube_start', 0);
          if ($start < 0) { $start = 0; }

          $end = (int) get_theme_mod('icpl_hero_bg_youtube_end', 0);
          if ($end < 0) { $end = 0; }
          // end が start 以下の場合は「終了指定なし」とみなす
          if ($end > 0 && $end <= $start) {
              $end = 0;
          }

          $origin = rawurlencode(home_url('/'));
          $src = 'https://www.youtube.com/embed/' . rawurlencode($icpl_video_id)
              . '?autoplay=1'
              . '&mute=1'
              . '&controls=0'
              . '&rel=0'
              . '&playsinline=1'
              . '&loop=1'
              . '&playlist=' . rawurlencode($icpl_video_id)
              . '&modestbranding=1'
              . '&iv_load_policy=3'
              . '&disablekb=1'
              . '&fs=0'
              . ($start > 0 ? '&start=' . (int) $start : '')
              . ($end > 0 ? '&end=' . (int) $end : '')
              . '&origin=' . $origin;
    ?>
      <iframe
        class="icpl-hero-yt"
        src="<?php echo esc_url($src); ?>"
        title="YouTube video player"
        frameborder="0"
        allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
        referrerpolicy="strict-origin-when-cross-origin"
        allowfullscreen
      ></iframe>
    <?php endif; ?>
  </div>

  <div class="icpl-hero-inner">

    <?php if ($hero_title): ?>
      <h1 class="icpl-hero-title"><?php echo esc_html($hero_title); ?></h1>
    <?php endif; ?>

    <?php if ($hero_text !== ''): ?>
      <div class="icpl-hero-text">
        <?php echo wp_kses_post(wpautop(esc_html($hero_text))); ?>
      </div>
    <?php endif; ?>

    <?php if ($cta_label && $cta_url): ?>
      <div class="icpl-hero-cta">
        <a href="<?php echo esc_url($cta_url); ?>" class="icpl-btn-primary"><?php echo esc_html($cta_label); ?></a>
      </div>
    <?php endif; ?>

  </div>
</section>
